<?php

namespace App\Imports;

use App\Models\User;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Events\AfterImport;
use Maatwebsite\Excel\Validators\Failure;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Illuminate\Contracts\Queue\ShouldQueue;
use Maatwebsite\Excel\Concerns\SkipsErrors;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use App\Http\Controllers\Services\Registration;
use App\Http\Controllers\StudentsController;
use App\Jobs\SendActivation;
use Illuminate\Support\Facades\Artisan;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\RegistersEventListeners;

class StudentImport implements
    ToModel,
    WithHeadingRow,
    SkipsOnError,
    WithValidation,
    SkipsOnFailure,
    WithChunkReading,
    ShouldQueue,
    WithEvents
{
    use Importable, SkipsErrors, SkipsFailures, RegistersEventListeners;

    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        return new User([
            'name' => $row['name'],
            'email' => $row['email'],
            'phone' => $row['phone'],
            'certificate_name'=>$row['longname'],
            'role' => 2,
        ]);
    }
    public function rules(): array
    {
        return [
            // Above is alias for as it always validates in batches
            'name' => 'required',
            'email' => 'required |email|unique:users',
        ]
        ;
    }
    public function customValidationMessages()
    {
        return [
            'name.required' => 'يرجى اضافة الاسم .',
            'email.required' => 'يرجى اضافة الإيميل .',
            'email.email' => 'يرجى اضافة إيميل صحيح .',
            'email.unique' => 'هذا الإيميل مستخدم من قبل  .',
        ];
    }
    public function chunkSize(): int
    {
        return 100;
    }

    public static function afterImport(AfterImport $event)
    {
    //    Registration::sendStudentActivation();
    } 

    public function onFailure(Failure ...$failure)
    {

    }
    

}
